/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.placebo.recipe.VanillaPacketDispatcher;

public abstract class EnchLibraryTile
extends BlockEntity {
    protected final Object2IntMap<Enchantment> points = new Object2IntOpenHashMap();
    protected final Object2IntMap<Enchantment> maxLevels = new Object2IntOpenHashMap();
    protected final Set<EnchLibraryContainer> activeContainers = new HashSet<EnchLibraryContainer>();
    protected final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new EnchLibItemHandler());
    protected final int maxLevel;
    protected final int maxPoints;

    public EnchLibraryTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxLevel) {
        super(type, pos, state);
        this.maxLevel = maxLevel;
        this.maxPoints = EnchLibraryTile.levelToPoints(maxLevel);
    }

    public void depositBook(ItemStack book) {
        if (book.m_41720_() != Items.f_42690_) {
            return;
        }
        Map enchs = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Map.Entry e : enchs.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            int newPoints = Math.min(this.maxPoints, this.points.getInt(e.getKey()) + EnchLibraryTile.levelToPoints((Integer)e.getValue()));
            if (newPoints < 0) {
                newPoints = this.maxPoints;
            }
            this.points.put((Object)((Enchantment)e.getKey()), newPoints);
            this.maxLevels.put((Object)((Enchantment)e.getKey()), Math.min(this.maxLevel, Math.max(this.maxLevels.getInt(e.getKey()), (Integer)e.getValue())));
        }
        if (enchs.size() > 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        this.m_6596_();
    }

    public void extractEnchant(ItemStack stack, Enchantment ench, int level) {
        int curLvl = EnchantmentHelper.m_44831_((ItemStack)stack).getOrDefault(ench, 0);
        if (stack.m_41619_() || !this.canExtract(ench, level, curLvl) || level == curLvl) {
            return;
        }
        Map enchs = EnchantmentHelper.m_44831_((ItemStack)stack);
        enchs.put(ench, level);
        EnchantmentHelper.m_44865_((Map)enchs, (ItemStack)stack);
        this.points.put((Object)ench, Math.max(0, this.points.getInt((Object)ench) - EnchLibraryTile.levelToPoints(level) + EnchLibraryTile.levelToPoints(curLvl)));
        if (!this.f_58857_.m_5776_()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        this.m_6596_();
    }

    public boolean canExtract(Enchantment ench, int level, int currentLevel) {
        return this.maxLevels.getInt((Object)ench) >= level && this.points.getInt((Object)ench) >= EnchLibraryTile.levelToPoints(level) - EnchLibraryTile.levelToPoints(currentLevel);
    }

    public static int levelToPoints(int level) {
        return (int)Math.pow(2.0, level - 1);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag points = new CompoundTag();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.m_128405_(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.m_128365_("Points", (Tag)points);
        CompoundTag levels = new CompoundTag();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.m_128405_(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.m_128365_("Levels", (Tag)levels);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag points = tag.m_128469_("Points");
        for (String s : points.m_128431_()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.m_128451_(s));
        }
        CompoundTag levels = tag.m_128469_("Levels");
        for (String s : levels.m_128431_()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.m_128451_(s));
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        CompoundTag points = tag.m_128469_("Points");
        for (String s : points.m_128431_()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.points.put((Object)ench, points.m_128451_(s));
        }
        CompoundTag levels = tag.m_128469_("Levels");
        for (String s : levels.m_128431_()) {
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(s));
            if (ench == null) continue;
            this.maxLevels.put((Object)ench, levels.m_128451_(s));
        }
        this.activeContainers.forEach(EnchLibraryContainer::onChanged);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        CompoundTag points = new CompoundTag();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.m_128405_(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.m_128365_("Points", (Tag)points);
        CompoundTag levels = new CompoundTag();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.m_128405_(((Enchantment)e.getKey()).getRegistryName().toString(), e.getIntValue());
        }
        tag.m_128365_("Levels", (Tag)levels);
        return tag;
    }

    public Object2IntMap<Enchantment> getPointsMap() {
        return this.points;
    }

    public Object2IntMap<Enchantment> getLevelsMap() {
        return this.maxLevels;
    }

    public void addListener(EnchLibraryContainer ctr) {
        this.activeContainers.add(ctr);
    }

    public void removeListener(EnchLibraryContainer ctr) {
        this.activeContainers.remove((Object)ctr);
    }

    public int getMax(Enchantment ench) {
        return Math.min(this.maxLevel, this.maxLevels.getInt((Object)ench));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private class EnchLibItemHandler
    implements IItemHandler {
        private EnchLibItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41720_() != Items.f_42690_ || stack.m_41613_() > 1) {
                return stack;
            }
            if (!simulate) {
                EnchLibraryTile.this.depositBook(stack);
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && stack.m_41720_() == Items.f_42690_;
        }
    }

    public static class EnderLibraryTile
    extends EnchLibraryTile {
        public EnderLibraryTile(BlockPos pos, BlockState state) {
            super(Apoth.Tiles.ENDER_LIBRARY, pos, state, 31);
        }
    }

    public static class BasicLibraryTile
    extends EnchLibraryTile {
        public BasicLibraryTile(BlockPos pos, BlockState state) {
            super(Apoth.Tiles.LIBRARY, pos, state, 16);
        }
    }
}

